import { Link, useLocation } from 'react-router-dom'
import { Scale } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <>
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Scale size={36} strokeWidth={2.5} className="logo-icon" />
              <span className="logo-text">LawConsult</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                История обращений
              </Link>
              <Link 
                to="/new" 
                className={`nav-link ${location.pathname === '/new' ? 'active' : ''}`}
              >
                Новая консультация
              </Link>
            </nav>
          </div>
        </div>
      </header>
      <main>{children}</main>
      <Footer />
    </>
  )
}

export default Layout

